#ifndef NODE_H
#define NODE_H

#pragma warning(disable:4786)

#include <vector>
#include <algorithm>

#include "animation.h"
#include "blind.h"

using namespace std;

enum nodeType
{
    geometryNode = 0,
    jointNode,
    unknownNode
};

typedef struct geomsorttag
{
    RpGeometry  *geom;
    int         *vertexMap;
    int         currentIndex;
} GeomSort;


/* Class representing a node in the scene */

class sceneNode
{
public:
    int         type;
    int         mdtIndex;
    int         parentMdtIndex;
    char        *name;
    int         numChildren;
    bool        hasSkinInfluences;
    bool        isSkinned;
    bool        isLit;
    bool        isTextured;
    int         numPolys;
    MObject     object;
    MDagPath    dagPath;
    int         mergeGroup;
    MIntArray   morphTargetKeys;
    animKeyList animKeys;
    RpAtomic    *atomic;
    RwFrame     *frame;
    RwV3d       objectOffset;
    RwV3d       objectScale;
    blindData   *mayaBlindData;
    bool        exportRpHAnim;
    vector<sceneNode *> mergedNodes;

    int             numRemappedVerts;
    int             numRemappedFaces;
    RwUInt16        *remappedFaces;
    RpMaterial      **remappedFaceMaterials;
    RwV3d           **remappedPositions;
    RwV3d           **remappedNormals;
    RwRGBA          *remappedPreLightColors;
    RwTexCoords     *remappedTexCoords;
    int             *unmappedVertexIndices;
    RwMatrixWeights *skinMatrixWeights;
    RwUInt32        *skinVertexIndices;
    int             *vertexMap;

    int             numRemappedVertsAfterMerge;
    int             numRemappedFacesAfterMerge;

    void        processNode();
    void        calculatePolyCount();
    void        calculateNodeType();
    void        checkSkinning();
    void        computeRwMatrix(RwMatrix *matrix, bool clearRoot);
    void        computeSkinnedRwMatrix(RwMatrix *matrix);
    void        sampleMayaMatrices();
    void        computeAnimation();
    void        checkTexturing();
    void        calculateMorphKeys();
    void        calculateRemappedGeometry();
    void        generateRwAtomic();
    void        buildSkinVertexMapping();
    void        generateSkinnedRwAtomic(RpClump *clump, unsigned int numNodes,
                    RwMatrix *invMatrices, RwUInt32 *animFlags, RwInt32 *tags);

    sceneNode(int mdtNodeIndex, int numberChildren, bool processSkin);
    ~sceneNode();

    sceneNode & operator*=(sceneNode &b);
};

/* General functions */
void        calculateOffsetMatrix(RwMatrix *out, RwMatrix *from, RwMatrix *to);
int         setSkinClusterEnvelopes(float envelope);
int         DtShapeGetLTM(int shapeID, float **matrix);
int         DtShapeGetLocalRotationPivot(int shapeID, float *x, float *y, float *z);
RpMaterial *buildVertexMap(RpMaterial *material, void *pData);
int         *calculateVertexMap(RpGeometry *geom);

#endif //NODE_H
